#include <windows>
#pragma option push -a1
#include <setupapi>
#pragma option pop
#include <iostream>
#include <assert>

#define HID_USAGE_PAGE_GENERIC      ((USAGE) 0x01) //hidusage.h
#define HID_USAGE_PAGE_LED          ((USAGE) 0x08)
#define HID_USAGE_GENERIC_JOYSTICK  ((USAGE) 0x04)

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//typedef unsigned int NTSTATUS;
PHIDP_PREPARSED_DATA preparsedData;

typedef struct _HIDP_CAPS { //hidpi.h
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;

HIDP_CAPS capabilities;
GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
HANDLE  hidDeviceObject = INVALID_HANDLE_VALUE;
//---------------------------------------------------------
typedef enum _HIDP_REPORT_TYPE { //hidpi.h
   HidP_Input,
   HidP_Output,
   HidP_Feature
}  HIDP_REPORT_TYPE;
//---------------------------------------------------------
typedef struct _HIDP_VALUE_CAPS { //hidpi.h
  USAGE UsagePage;
  UCHAR ReportID;
  BOOLEAN IsAlias;
  USHORT BitField;
  USHORT LinkCollection;
  USAGE LinkUsage;
  USAGE LinkUsagePage;
  BOOLEAN IsRange;
  BOOLEAN IsStringRange;
  BOOLEAN IsDesignatorRange;
  BOOLEAN IsAbsolute;
  BOOLEAN HasNull;
  UCHAR Reserved;
  USHORT BitSize;
  USHORT ReportCount;
  USHORT Reserved2[5];
  ULONG UnitsExp;
  ULONG Units;
  LONG LogicalMin, LogicalMax;
  LONG PhysicalMin, PhysicalMax;
    union {
      struct {
        USAGE UsageMin, UsageMax;
        USHORT StringMin, StringMax;
        USHORT DesignatorMin, DesignatorMax;
        USHORT DataIndexMin, DataIndexMax;
      } Range;
      struct {
        USAGE Usage, Reserved1;
        USHORT StringIndex, Reserved2;
        USHORT DesignatorIndex, Reserved3;
        USHORT DataIndex, Reserved4;
      } NotRange;
    };
} HIDP_VALUE_CAPS, * PHIDP_VALUE_CAPS;
//---------------------------------------------------------
int main()
{
  unsigned int (__stdcall *HidP_GetValueCaps)(IN HIDP_REPORT_TYPE  ReportType,
               OUT PHIDP_VALUE_CAPS  ValueCaps,IN OUT PULONG  ValueCapsLength,
               IN PHIDP_PREPARSED_DATA  PreparsedData);
  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
  long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);
  bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                      OUT PHIDP_PREPARSED_DATA *PreparsedData);
  bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);


  hHidLib = LoadLibrary("C:\\Windows\\System32\\HID.DLL");
  if (!hHidLib)
    displayError("Bd doczenia biblioteki HID.DLL.");

  (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
  (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
  (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
  (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");

  (FARPROC&) HidP_GetValueCaps=GetProcAddress(hHidLib,
                                             "HidP_GetValueCaps");

   if (!HidD_GetHidGuid || !HidP_GetCaps || !HidD_GetPreparsedData
       || !HidD_FreePreparsedData || !HidP_GetValueCaps){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, "vid_22ba")){
           cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";
           hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                     GENERIC_READ, FILE_SHARE_READ,
                                     NULL,OPEN_EXISTING,0,NULL);
           if(hidDeviceObject==INVALID_HANDLE_VALUE)
             displayError("Nie mona otworzy urzdzenia do transmisji");
             else
               break;
       }
       releaseMemory(deviceInterfaceDetailData);
   };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);

   if(HidD_GetPreparsedData(hidDeviceObject, &preparsedData)){
      HidP_GetCaps(preparsedData, &capabilities);

      PULONG  valueCapsLength;
      HIDP_VALUE_CAPS *valueCaps = new \
      		HIDP_VALUE_CAPS[capabilities.NumberOutputValueCaps];

      HidP_GetValueCaps(HidP_Output, valueCaps, valueCapsLength, preparsedData);

      for(USHORT i = 0; i<capabilities.NumberOutputValueCaps;i++) {
         printf("ValueCaps[%d].UsagePage= x%x\n", i, valueCaps[i].UsagePage);
         printf("ValueCaps[%d].ReportID= x%x\n", i, valueCaps[i].ReportID);
         printf("ValueCaps[%d].IsAlias= x%x\n", i, valueCaps[i].IsAlias);
         printf("ValueCaps[%d].BitField= %d\n", i, valueCaps[i].BitField);
         printf("ValueCaps[%d].LinkCollection= x%x\n", i,
                                                valueCaps[i].LinkCollection);
         printf("ValueCaps[%d].LinkUsage= x%x\n", i, valueCaps[i].LinkUsage);
         printf("ValueCaps[%d].LinkUsagePage= 0x%x\n", i,
                                                 valueCaps[i].LinkUsagePage);
         printf("ValueCaps[%d].IsRange= %d\n", i, valueCaps[i].IsRange);
         printf("ValueCaps[%d].IsStringRange= %d\n", i,
                                                valueCaps[i].IsStringRange);
         printf("ValueCaps[%d].IsDesignatorRange= %d\n", i,
                                            valueCaps[i].IsDesignatorRange);
         printf("ValueCaps[%d].IsAbsolute= %d\n", i, valueCaps[i].IsAbsolute);
         printf("ValueCaps[%d].HasNull= %d\n", i, valueCaps[i].HasNull);
         printf("ValueCaps[%d].BitSize= %d\n", i, valueCaps[i].BitSize);
         printf("ValueCaps[%d].ReportCount= %d\n", i, valueCaps[i].ReportCount);
         printf("ValueCaps[%d].UnitsExp= %d\n", i, valueCaps[i].UnitsExp);
         printf("ValueCaps[%d].Units= %d\n", i, valueCaps[i].Units);
         printf("ValueCaps[%d].LogicalMin= %d\n", i, valueCaps[i].LogicalMin);
         printf("ValueCaps[%d].LogicalMax= %d\n", i, valueCaps[i].LogicalMax);
         printf("ValueCaps[%d].PhysicalMin= %d\n", i, valueCaps[i].PhysicalMin);
         printf("ValueCaps[%d].PhysicalMax= %d\n", i, valueCaps[i].PhysicalMax);
         printf("ValueCaps[%d].Range= %d\n", i, valueCaps[i].Range);
         printf("ValueCaps[%d].Range.UsageMin= %d\n", i,
                                                   valueCaps[i].Range.UsageMin);
         printf("ValueCaps[%d].Range.UsageMax= %d\n", i,
                                                   valueCaps[i].Range.UsageMax);
         printf("ValueCaps[%d].Range.StringMin= %d\n", i,
                                                  valueCaps[i].Range.StringMin);
         printf("ValueCaps[%d].Range.StringMax= %d\n", i,
                                                  valueCaps[i].Range.StringMax);
         printf("ValueCaps[%d].Range.DesignatorMin= %d\n", i,
                                              valueCaps[i].Range.DesignatorMin);
         printf("ValueCaps[%d].Range.DesignatorMax= %d\n", i,
                                              valueCaps[i].Range.DesignatorMax);
         printf("ValueCaps[%d].Range.DataIndexMin= %d\n", i,
                                               valueCaps[i].Range.DataIndexMin);
         printf("ValueCaps[%d].Range.DataIndexMax= %d\n", i,
                                               valueCaps[i].Range.DataIndexMax);
         printf("ValueCaps[%d].NotRange= %d\n", i, valueCaps[i].NotRange);
         printf("ValueCaps[%d].NotRange.Usage= x%x\n\n", i,
                                                   valueCaps[i].NotRange.Usage);

         switch (valueCaps[i].UsagePage) {
           case HID_USAGE_PAGE_LED:
              printf("\Usage Page -> LEDs Page\n");
           break;
           /*...*/
           default :
             printf("...");
         }
         switch (valueCaps[i].LinkUsage) {
           case HID_USAGE_GENERIC_JOYSTICK:
              printf("\Link Usage -> Generic Joystick Page\n");
           break;
           /*...*/
           default :
             printf("...");
         }
         switch (valueCaps[i].LinkUsagePage) {
           case HID_USAGE_PAGE_GENERIC:
              printf("\Link Usage Page -> Generic Desktop Page\n\n");
           break;
           /*...*/
           default :
             printf("...");
         }
      }
      releaseMemory(valueCaps);
      HidD_FreePreparsedData(preparsedData);
      CloseHandle(hidDeviceObject);
   }
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------
 
